/*
 * Decompiled with CFR 0.152.
 */
package pa1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class Server {
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private BufferedReader input;
    private PrintStream output;
    private String dateString;
    private boolean post;
    private StringBuilder responseData = new StringBuilder();

    private void getFileIO() throws Exception {
        FileReader inputStreamReader = new FileReader("src/pa1/get");
        this.input = new BufferedReader(inputStreamReader);
        this.output = System.out;
    }

    private void postFileIO() throws Exception {
        FileReader inputStreamReader = new FileReader("src/pa1/post");
        this.input = new BufferedReader(inputStreamReader);
        this.output = System.out;
    }

    private void socketIO() throws Exception {
        try {
            this.serverSocket = new ServerSocket(4444);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: 4444.");
            System.exit(1);
        }
        try {
            this.clientSocket = this.serverSocket.accept();
        }
        catch (IOException e) {
            System.err.println("Accept failed.");
            System.exit(1);
        }
        OutputStream outputStream = this.clientSocket.getOutputStream();
        this.output = new PrintStream(outputStream, true);
        InputStream inputStream = this.clientSocket.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.input = new BufferedReader(inputStreamReader);
    }

    private void processRequestLine() throws Exception {
        this.dateString = new Date().toGMTString();
        this.responseData.append("<html>\n  <body>\n");
        this.responseData.append("    <h1>A Dynamic Web Page</h1>\n");
        this.responseData.append("    <p>");
        this.responseData.append(this.dateString);
        this.responseData.append("</p>\n");
        String requestLine = this.input.readLine();
        this.responseData.append("    <h3>");
        this.responseData.append(requestLine);
        this.responseData.append("</h3>\n");
        this.post = requestLine.startsWith("POST");
    }

    private void processHeaderLines() throws Exception {
        String headerLine = this.input.readLine();
        while (headerLine != null && headerLine.length() > 0) {
            int colon = headerLine.indexOf(":");
            String name = headerLine.substring(0, colon);
            this.responseData.append("    <h3>");
            this.responseData.append(name);
            this.responseData.append("</h3>\n");
            String value = headerLine.substring(colon + 2);
            this.responseData.append("    <p>");
            this.responseData.append(value);
            this.responseData.append("</p>\n");
            headerLine = this.input.readLine();
        }
    }

    private void processEntityBody() throws Exception {
        this.responseData.append("    <h3>Post Data</h3>\n");
        this.responseData.append("    </pre>");
        String dataLine = this.input.readLine();
        while (dataLine != null) {
            this.responseData.append(dataLine);
            this.responseData.append("\n");
            dataLine = this.input.readLine();
        }
        this.responseData.append("    </pre>\n");
    }

    private void sendResponseHeader() {
        this.output.println("HTTP/1.1 200 OK");
        this.output.println("Connection: close");
        this.output.println("Date: " + this.dateString);
        this.output.println("Server: A Dynamic Server");
        this.output.println("Last-Modified: " + this.dateString);
        this.output.println("Content-length: " + this.responseData.length());
        this.output.println("Content-Type: text/html");
        this.output.println();
    }

    private void sendResponseData() {
        this.responseData.append("  </body>\n</html>\n");
        this.output.print(this.responseData.toString());
    }

    private void run() throws Exception {
        this.socketIO();
        this.processRequestLine();
        this.processHeaderLines();
        if (this.post) {
            this.processEntityBody();
        }
        this.sendResponseHeader();
        this.sendResponseData();
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new Server().run();
    }
}

