package pa1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

/**
 *
 */
public class Server {

  private ServerSocket serverSocket;
  private Socket clientSocket;
  private BufferedReader theInput;
  private PrintStream theOutput;
  private String dateString;
  private boolean post;
  private StringBuilder responseData;

  public Server() {
    responseData = new StringBuilder();
  }

  /**
   * Set up theInput from the file named "get" and set up theOutput to
   * System.out.
   * This is for testing GET request handling.
   * @throws Exception 
   */
  private void getFileIO()
      throws Exception {
    InputStreamReader inputStreamReader =
        new FileReader("src/pa1/get");
    theInput = new BufferedReader(inputStreamReader);
    theOutput = System.out;
  }

  /**
   * Set up theInput from the file named "post" and set up theOutput to
   * System.out.
   * This is for testing POST request handling.
   * @throws Exception 
   */
  private void postFileIO()
      throws Exception {
    InputStreamReader inputStreamReader =
        new FileReader("src/pa1/post");
    theInput = new BufferedReader(inputStreamReader);
    theOutput = System.out;
  }

  /**
   * Create serverSocket and clientSocket and set up theInput from clientSocket
   * and set up theOutput to clientSocket.
   * This is for final testing using a live server.
   * @throws Exception 
   */
  private void socketIO()
      throws Exception {
    // FIXME - implement the method comment.
    // This is similar to code in Oracle's Knock-Knock server except that you
    // should set up theOutput as a PrintStream instead of a PrintWriter.
  }

  /**
   * Initialize dateString and add starting tags to responseData.
   * Then read the request line of the request.
   * Add an <h3> containing the request to responseData.
   * Set post to true if the request is a "POST" request.
   * @throws Exception 
   */
  private void processRequestLine()
      throws Exception {
    // This implements the first line of the method comment.
    dateString = new Date().toGMTString();
    responseData.append("<html>\n  <body>\n");
    responseData.append("    <h1>A Dynamic Web Page</h1>\n");
    responseData.append("    <p>");
    responseData.append(dateString);
    responseData.append("</p>\n");
    // FIXME - implement the rest of the method comment.
  }

  /**
   * Read all of the header lines and add sections for each to responseData.
   * Each section has an <h3> tag containing the attribute name and a <p> tag
   * containing the attribute value.
   * @throws Exception 
   */
  private void processHeaderLines()
      throws Exception {
    // FIXME - implement the method comment.
  }

  /**
   * Read the request entity body and add a section for it to responseData.
   * It should have an <h3> tag with contents "Post Data" and a <pre> tag
   * containing the request entity body.
   * @throws Exception 
   */
  private void processEntityBody()
      throws Exception {
    // FIXME - implement the method comment.
  }

  /**
   * Send the response header to theOutput.
   */
  private void sendResponseHeader() {
    // FIXME - implement the method comment.
  }

  /**
   * Finish building responseData and send it to theOutput.
   */
  private void sendResponseData() {
    responseData.append("  </body>\n</html>\n");
    theOutput.print(responseData.toString());
  }

  /**
   * Run the server for a single request.
   * @throws Exception 
   */
  private void run()
      throws Exception {
    // choose one of the following:
    // getFileIO() - input from the test file "get", output to System.out
    // postFileIO() - input from the test file "post", output to System.out
    // socketFileIO() - input from the socket, output to the socket
    getFileIO();
    processRequestLine();
    processHeaderLines();
    if (post) {
      processEntityBody();
    }
    sendResponseHeader();
    sendResponseData();
    if (clientSocket != null) {
      clientSocket.close();
    }
    if (serverSocket != null) {
      serverSocket.close();
    }
  }

  /**
   * @param args not used
   */
  public static void main(String[] args)
      throws Exception {
    new Server().run();
  }

}
